/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.AsyncRpcChannel;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.FailedServerException;
import org.apache.hadoop.hbase.ipc.FailedServers;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.StoppedRpcClientException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.JVM;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class AsyncRpcClient
extends AbstractRpcClient {
    public static final String CLIENT_MAX_THREADS = "hbase.rpc.client.threads.max";
    public static final String USE_NATIVE_TRANSPORT = "hbase.rpc.client.nativetransport";
    public static final String USE_GLOBAL_EVENT_LOOP_GROUP = "hbase.rpc.client.globaleventloopgroup";
    private static final HashedWheelTimer WHEEL_TIMER = new HashedWheelTimer(Threads.newDaemonThreadFactory((String)"AsyncRpcChannel-timer"), 100L, TimeUnit.MILLISECONDS);
    private static final ChannelInitializer<SocketChannel> DEFAULT_CHANNEL_INITIALIZER = new ChannelInitializer<SocketChannel>(){

        protected void initChannel(SocketChannel ch) throws Exception {
        }
    };
    protected final AtomicInteger callIdCnt = new AtomicInteger();
    private final PoolMap<Integer, AsyncRpcChannel> connections;
    final FailedServers failedServers;
    @VisibleForTesting
    final Bootstrap bootstrap;
    private final boolean useGlobalEventLoopGroup;
    @VisibleForTesting
    static Pair<EventLoopGroup, Class<? extends Channel>> GLOBAL_EVENT_LOOP_GROUP;
    private boolean closed = false;

    private static synchronized Pair<EventLoopGroup, Class<? extends Channel>> getGlobalEventLoopGroup(Configuration conf) {
        if (GLOBAL_EVENT_LOOP_GROUP == null) {
            GLOBAL_EVENT_LOOP_GROUP = AsyncRpcClient.createEventLoopGroup(conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Create global event loop group " + ((EventLoopGroup)GLOBAL_EVENT_LOOP_GROUP.getFirst()).getClass().getSimpleName()));
            }
        }
        return GLOBAL_EVENT_LOOP_GROUP;
    }

    private static Pair<EventLoopGroup, Class<? extends Channel>> createEventLoopGroup(Configuration conf) {
        int maxThreads = conf.getInt(CLIENT_MAX_THREADS, 0);
        boolean epollEnabled = conf.getBoolean(USE_NATIVE_TRANSPORT, false);
        if (epollEnabled && JVM.isLinux() && JVM.isAmd64()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Create EpollEventLoopGroup with maxThreads = " + maxThreads));
            }
            return new Pair((Object)new EpollEventLoopGroup(maxThreads, Threads.newDaemonThreadFactory((String)"AsyncRpcChannel")), EpollSocketChannel.class);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create NioEventLoopGroup with maxThreads = " + maxThreads));
        }
        return new Pair((Object)new NioEventLoopGroup(maxThreads, Threads.newDaemonThreadFactory((String)"AsyncRpcChannel")), NioSocketChannel.class);
    }

    @VisibleForTesting
    AsyncRpcClient(Configuration configuration, String clusterId, SocketAddress localAddress, ChannelInitializer<SocketChannel> channelInitializer) {
        super(configuration, clusterId, localAddress);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Starting async Hbase RPC client");
        }
        this.useGlobalEventLoopGroup = this.conf.getBoolean(USE_GLOBAL_EVENT_LOOP_GROUP, true);
        Pair<EventLoopGroup, Class<? extends Channel>> eventLoopGroupAndChannelClass = this.useGlobalEventLoopGroup ? AsyncRpcClient.getGlobalEventLoopGroup(configuration) : AsyncRpcClient.createEventLoopGroup(configuration);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Use " + (this.useGlobalEventLoopGroup ? "global" : "individual") + " event loop group " + ((EventLoopGroup)eventLoopGroupAndChannelClass.getFirst()).getClass().getSimpleName()));
        }
        this.connections = new PoolMap(AsyncRpcClient.getPoolType(configuration), AsyncRpcClient.getPoolSize(configuration));
        this.failedServers = new FailedServers(configuration);
        int operationTimeout = configuration.getInt("hbase.client.operation.timeout", Integer.MAX_VALUE);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)eventLoopGroupAndChannelClass.getFirst())).channel((Class)eventLoopGroupAndChannelClass.getSecond())).option(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay)).option(ChannelOption.SO_KEEPALIVE, (Object)this.tcpKeepAlive)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)operationTimeout);
        if (channelInitializer == null) {
            channelInitializer = DEFAULT_CHANNEL_INITIALIZER;
        }
        this.bootstrap.handler(channelInitializer);
        if (localAddress != null) {
            this.bootstrap.localAddress(localAddress);
        }
    }

    public AsyncRpcClient(Configuration configuration, String clusterId, SocketAddress localAddress) {
        this(configuration, clusterId, localAddress, null);
    }

    @Override
    protected Pair<Message, CellScanner> call(PayloadCarryingRpcController pcrc, Descriptors.MethodDescriptor md, Message param, Message returnType, User ticket, InetSocketAddress addr) throws IOException, InterruptedException {
        if (pcrc == null) {
            pcrc = new PayloadCarryingRpcController();
        }
        AsyncRpcChannel connection = this.createRpcChannel(md.getService().getName(), addr, ticket);
        Promise<Message> promise = connection.callMethod(md, pcrc, param, returnType);
        long timeout = pcrc.hasCallTimeout() ? (long)pcrc.getCallTimeout() : 0L;
        try {
            Message response = timeout > 0L ? (Message)promise.get(timeout, TimeUnit.MILLISECONDS) : (Message)promise.get();
            return new Pair((Object)response, (Object)pcrc.cellScanner());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
        catch (TimeoutException e) {
            throw new CallTimeoutException(promise.toString());
        }
    }

    private void callMethod(Descriptors.MethodDescriptor md, final PayloadCarryingRpcController pcrc, Message param, Message returnType, User ticket, InetSocketAddress addr, final RpcCallback<Message> done) {
        try {
            AsyncRpcChannel connection = this.createRpcChannel(md.getService().getName(), addr, ticket);
            connection.callMethod(md, pcrc, param, returnType).addListener((GenericFutureListener)new GenericFutureListener<Future<Message>>(){

                public void operationComplete(Future<Message> future) throws Exception {
                    if (!future.isSuccess()) {
                        Throwable cause = future.cause();
                        if (cause instanceof IOException) {
                            pcrc.setFailed((IOException)cause);
                        } else {
                            pcrc.setFailed(new IOException(cause));
                        }
                    } else {
                        try {
                            done.run(future.get());
                        }
                        catch (ExecutionException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof IOException) {
                                pcrc.setFailed((IOException)cause);
                            } else {
                                pcrc.setFailed(new IOException(cause));
                            }
                        }
                        catch (InterruptedException e) {
                            pcrc.setFailed(new IOException(e));
                        }
                    }
                }
            });
        }
        catch (FailedServerException | StoppedRpcClientException e) {
            pcrc.setFailed((IOException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping async HBase RPC client");
        }
        PoolMap<Integer, AsyncRpcChannel> poolMap = this.connections;
        synchronized (poolMap) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (AsyncRpcChannel conn : this.connections.values()) {
                conn.close(null);
            }
        }
        if (!this.useGlobalEventLoopGroup) {
            this.bootstrap.group().shutdownGracefully();
        }
    }

    public CellScanner createCellScanner(byte[] cellBlock) throws IOException {
        return this.ipcUtil.createCellScanner(this.codec, this.compressor, cellBlock);
    }

    public ByteBuffer buildCellBlock(CellScanner cells) throws IOException {
        return this.ipcUtil.buildCellBlock(this.codec, this.compressor, cells);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncRpcChannel createRpcChannel(String serviceName, InetSocketAddress location, User ticket) throws StoppedRpcClientException, FailedServerException {
        AsyncRpcChannel rpcChannel;
        if (this.failedServers.isFailedServer(location)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not trying to connect to " + location + " this server is in the failed servers list"));
            }
            throw new FailedServerException("This server is in the failed servers list: " + location);
        }
        int hashCode = ConnectionId.hashCode(ticket, serviceName, location);
        PoolMap<Integer, AsyncRpcChannel> poolMap = this.connections;
        synchronized (poolMap) {
            if (this.closed) {
                throw new StoppedRpcClientException();
            }
            rpcChannel = this.connections.get(hashCode);
            if (rpcChannel == null) {
                rpcChannel = new AsyncRpcChannel(this.bootstrap, this, ticket, serviceName, location);
                this.connections.put(hashCode, rpcChannel);
            }
        }
        return rpcChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelConnections(ServerName sn) {
        PoolMap<Integer, AsyncRpcChannel> poolMap = this.connections;
        synchronized (poolMap) {
            for (AsyncRpcChannel rpcChannel : this.connections.values()) {
                if (!rpcChannel.isAlive() || rpcChannel.address.getPort() != sn.getPort() || !rpcChannel.address.getHostName().contentEquals(sn.getHostname())) continue;
                LOG.info((Object)("The server on " + sn.toString() + " is dead - stopping the connection " + rpcChannel.toString()));
                rpcChannel.close(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(AsyncRpcChannel connection) {
        int connectionHashCode = connection.getConnectionHashCode();
        PoolMap<Integer, AsyncRpcChannel> poolMap = this.connections;
        synchronized (poolMap) {
            AsyncRpcChannel connectionInPool = this.connections.get(connectionHashCode);
            if (connectionInPool == connection) {
                this.connections.remove(connectionHashCode);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("%s already removed, expected instance %08x, actual %08x", connection.toString(), System.identityHashCode(connection), System.identityHashCode(connectionInPool)));
            }
        }
    }

    public RpcChannel createRpcChannel(ServerName sn, User user, int rpcTimeout) {
        return new RpcChannelImplementation(this, sn, user, rpcTimeout);
    }

    Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        return WHEEL_TIMER.newTimeout(task, delay, unit);
    }

    @VisibleForTesting
    public static class RpcChannelImplementation
    implements RpcChannel {
        private final InetSocketAddress isa;
        private final AsyncRpcClient rpcClient;
        private final User ticket;
        private final int channelOperationTimeout;

        protected RpcChannelImplementation(AsyncRpcClient rpcClient, ServerName sn, User ticket, int channelOperationTimeout) {
            this.isa = new InetSocketAddress(sn.getHostname(), sn.getPort());
            this.rpcClient = rpcClient;
            this.ticket = ticket;
            this.channelOperationTimeout = channelOperationTimeout;
        }

        public void callMethod(Descriptors.MethodDescriptor md, RpcController controller, Message param, Message returnType, RpcCallback<Message> done) {
            PayloadCarryingRpcController pcrc;
            if (controller != null) {
                pcrc = (PayloadCarryingRpcController)controller;
                if (!pcrc.hasCallTimeout()) {
                    pcrc.setCallTimeout(this.channelOperationTimeout);
                }
            } else {
                pcrc = new PayloadCarryingRpcController();
                pcrc.setCallTimeout(this.channelOperationTimeout);
            }
            this.rpcClient.callMethod(md, pcrc, param, returnType, this.ticket, this.isa, (RpcCallback<Message>)done);
        }
    }
}

