/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyNonPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyUnionObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyUnion
extends LazyNonPrimitive<LazyUnionObjectInspector> {
    private boolean parsed;
    private int startPosition;
    private Object field;
    private byte tag;
    private boolean fieldInited = false;
    private boolean tagSet = false;
    private boolean fieldSet = false;

    public LazyUnion(LazyUnionObjectInspector oi) {
        super(oi);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        super.init(bytes, start, length);
        this.parsed = false;
    }

    private void parse() {
        byte separator = ((LazyUnionObjectInspector)this.oi).getSeparator();
        boolean isEscaped = ((LazyUnionObjectInspector)this.oi).isEscaped();
        byte escapeChar = ((LazyUnionObjectInspector)this.oi).getEscapeChar();
        boolean tagStarted = false;
        boolean tagParsed = false;
        int tagStart = -1;
        int tagEnd = -1;
        int unionByteEnd = this.start + this.length;
        byte[] bytes = this.bytes.getData();
        for (int fieldByteEnd = this.start; fieldByteEnd < unionByteEnd; ++fieldByteEnd) {
            if (bytes[fieldByteEnd] != separator) {
                if (isEscaped && bytes[fieldByteEnd] == escapeChar && fieldByteEnd + 1 < unionByteEnd) {
                    ++fieldByteEnd;
                    continue;
                }
                if (tagStarted) continue;
                tagStart = fieldByteEnd;
                tagStarted = true;
                continue;
            }
            if (tagParsed) continue;
            tagEnd = fieldByteEnd - 1;
            this.startPosition = fieldByteEnd + 1;
            tagParsed = true;
        }
        this.tag = LazyByte.parseByte(bytes, tagStart, tagEnd - tagStart + 1);
        this.field = LazyFactory.createLazyObject(((LazyUnionObjectInspector)this.oi).getObjectInspectors().get(this.tag));
        this.fieldInited = false;
        this.parsed = true;
    }

    private Object uncheckedGetField() {
        Text nullSequence = ((LazyUnionObjectInspector)this.oi).getNullSequence();
        int fieldLength = this.start + this.length - this.startPosition;
        if (fieldLength != 0 && fieldLength == nullSequence.getLength() && LazyUtils.compare(this.bytes.getData(), this.startPosition, fieldLength, nullSequence.getBytes(), 0, nullSequence.getLength()) == 0) {
            return null;
        }
        if (!this.fieldInited) {
            this.fieldInited = true;
            ((LazyObject)this.field).init(this.bytes, this.startPosition, fieldLength);
        }
        return ((LazyObject)this.field).getObject();
    }

    public Object getField() {
        if (this.fieldSet) {
            return this.field;
        }
        if (!this.parsed) {
            this.parse();
        }
        return this.uncheckedGetField();
    }

    public byte getTag() {
        if (this.tagSet) {
            return this.tag;
        }
        if (!this.parsed) {
            this.parse();
        }
        return this.tag;
    }

    public void setField(Object field) {
        this.field = field;
        this.fieldSet = true;
    }

    public void setTag(byte tag) {
        this.tag = tag;
        this.tagSet = true;
    }
}

