/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.AvaticaSite;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.remote.TypedValue;

public abstract class AvaticaPreparedStatement
extends AvaticaStatement
implements PreparedStatement,
ParameterMetaData {
    private final ResultSetMetaData resultSetMetaData;
    private Calendar calendar;
    protected final TypedValue[] slots;
    protected final List<List<TypedValue>> parameterValueBatch;

    protected AvaticaPreparedStatement(AvaticaConnection connection, Meta.StatementHandle h, Meta.Signature signature, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, h, resultSetType, resultSetConcurrency, resultSetHoldability, signature);
        this.slots = new TypedValue[signature.parameters.size()];
        this.resultSetMetaData = connection.factory.newResultSetMetaData(this, signature);
        this.parameterValueBatch = new ArrayList<List<TypedValue>>();
    }

    @Override
    protected List<TypedValue> getParameterValues() {
        return Arrays.asList(this.slots);
    }

    protected List<TypedValue> copyParameterValues() {
        ArrayList<TypedValue> copy = new ArrayList<TypedValue>(this.slots.length);
        for (TypedValue value : this.slots) {
            copy.add(value);
        }
        return copy;
    }

    protected synchronized Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(this.connection.getTimeZone());
        }
        return this.calendar;
    }

    protected List<List<TypedValue>> getParameterValueBatch() {
        return this.parameterValueBatch;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.updateCount = -1L;
        Meta.Signature sig = this.getSignature();
        return this.getConnection().executeQueryInternal(this, sig, null, new QueryState(sig.sql), false);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this;
    }

    @Override
    public final int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.getConnection().executeQueryInternal(this, null, null, new QueryState(this.getSignature().sql), true);
        return this.updateCount;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getSite(parameterIndex).setNull(sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getSite(parameterIndex).setBoolean(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getSite(parameterIndex).setByte(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getSite(parameterIndex).setShort(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getSite(parameterIndex).setInt(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getSite(parameterIndex).setLong(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getSite(parameterIndex).setFloat(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getSite(parameterIndex).setDouble(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getSite(parameterIndex).setBigDecimal(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.getSite(parameterIndex).setString(x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getSite(parameterIndex).setBytes(x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getSite(parameterIndex).setAsciiStream(x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getSite(parameterIndex).setUnicodeStream(x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getSite(parameterIndex).setBinaryStream(x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.getSite(parameterIndex).setObject(x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getSite(parameterIndex).setObject(x);
    }

    @Override
    public boolean execute() throws SQLException {
        this.updateCount = -1L;
        this.getConnection().executeQueryInternal(this, this.getSignature(), null, new QueryState(this.getSignature().sql), false);
        return this.openResultSet != null && !this.openResultSet.isClosed();
    }

    @Override
    public void addBatch() throws SQLException {
        this.parameterValueBatch.add(this.copyParameterValues());
    }

    @Override
    public void clearBatch() {
        this.parameterValueBatch.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return AvaticaUtils.toSaturatedInts(this.executeLargeBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            long[] lArray = this.getConnection().executeBatchUpdateInternal(this);
            return lArray;
        }
        finally {
            this.parameterValueBatch.clear();
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getSite(parameterIndex).setCharacterStream(reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.getSite(parameterIndex).setRef(x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.getSite(parameterIndex).setBlob(x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.getSite(parameterIndex).setClob(x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.getSite(parameterIndex).setArray(x);
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.resultSetMetaData;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar calendar) throws SQLException {
        this.getSite(parameterIndex).setDate(x, calendar);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, this.getCalendar());
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar calendar) throws SQLException {
        this.getSite(parameterIndex).setTime(x, calendar);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, this.getCalendar());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar calendar) throws SQLException {
        this.getSite(parameterIndex).setTimestamp(x, calendar);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, this.getCalendar());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getSite(parameterIndex).setNull(sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.getSite(parameterIndex).setURL(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.getSite(parameterIndex).setObject(x, targetSqlType, scaleOrLength);
    }

    protected AvaticaParameter getParameter(int param) throws SQLException {
        try {
            return this.getSignature().parameters.get(param - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.connection.helper.toSQLException(this.connection.helper.createException("parameter ordinal " + param + " out of range"));
        }
    }

    protected AvaticaSite getSite(int param) throws SQLException {
        AvaticaParameter parameter = this.getParameter(param);
        return new AvaticaSite(parameter, this.getCalendar(), param - 1, this.slots);
    }

    @Override
    public int getParameterCount() {
        return this.getSignature().parameters.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int index) throws SQLException {
        return this.getParameter((int)index).signed;
    }

    @Override
    public int getPrecision(int index) throws SQLException {
        return this.getParameter((int)index).precision;
    }

    @Override
    public int getScale(int index) throws SQLException {
        return this.getParameter((int)index).scale;
    }

    @Override
    public int getParameterType(int index) throws SQLException {
        return this.getParameter((int)index).parameterType;
    }

    @Override
    public String getParameterTypeName(int index) throws SQLException {
        return this.getParameter((int)index).typeName;
    }

    @Override
    public String getParameterClassName(int index) throws SQLException {
        return this.getParameter((int)index).className;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        AvaticaParameter paramDef = this.getParameter(param);
        return 1;
    }
}

