/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.thrift.DelegationTokenIdentifier;
import org.apache.hadoop.hive.thrift.DelegationTokenStore;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;

public class MemoryTokenStore
implements DelegationTokenStore {
    private final Map<Integer, String> masterKeys = new ConcurrentHashMap<Integer, String>();
    private final ConcurrentHashMap<DelegationTokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation> tokens = new ConcurrentHashMap();
    private final AtomicInteger masterKeySeq = new AtomicInteger();
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public int addMasterKey(String s) {
        int keySeq = this.masterKeySeq.getAndIncrement();
        this.masterKeys.put(keySeq, s);
        return keySeq;
    }

    @Override
    public void updateMasterKey(int keySeq, String s) {
        this.masterKeys.put(keySeq, s);
    }

    @Override
    public boolean removeMasterKey(int keySeq) {
        return this.masterKeys.remove(keySeq) != null;
    }

    @Override
    public String[] getMasterKeys() {
        return this.masterKeys.values().toArray(new String[0]);
    }

    @Override
    public boolean addToken(DelegationTokenIdentifier tokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation token) {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = this.tokens.putIfAbsent(tokenIdentifier, token);
        return tokenInfo == null;
    }

    @Override
    public boolean removeToken(DelegationTokenIdentifier tokenIdentifier) {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = this.tokens.remove((Object)tokenIdentifier);
        return tokenInfo != null;
    }

    @Override
    public AbstractDelegationTokenSecretManager.DelegationTokenInformation getToken(DelegationTokenIdentifier tokenIdentifier) {
        return this.tokens.get((Object)tokenIdentifier);
    }

    @Override
    public List<DelegationTokenIdentifier> getAllDelegationTokenIdentifiers() {
        ArrayList<DelegationTokenIdentifier> result = new ArrayList<DelegationTokenIdentifier>(this.tokens.size());
        for (DelegationTokenIdentifier id : this.tokens.keySet()) {
            result.add(id);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void init(Object hmsHandler, HadoopThriftAuthBridge.Server.ServerMode smode) throws DelegationTokenStore.TokenStoreException {
    }
}

