/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.tools.RelBuilderFactory;

public class SortUnionTransposeRule
extends RelOptRule {
    public static final SortUnionTransposeRule INSTANCE = new SortUnionTransposeRule(false);
    public static final SortUnionTransposeRule MATCH_NULL_FETCH = new SortUnionTransposeRule(true);
    private final boolean matchNullFetch;

    private SortUnionTransposeRule(boolean matchNullFetch) {
        this(Sort.class, Union.class, matchNullFetch, RelFactories.LOGICAL_BUILDER, "SortUnionTransposeRule:default");
    }

    public SortUnionTransposeRule(Class<? extends Sort> sortClass, Class<? extends Union> unionClass, boolean matchNullFetch, RelBuilderFactory relBuilderFactory, String description) {
        super(SortUnionTransposeRule.operand(sortClass, SortUnionTransposeRule.operand(unionClass, SortUnionTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, description);
        this.matchNullFetch = matchNullFetch;
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        Union union = (Union)call.rel(1);
        return union.all && sort.offset == null && (this.matchNullFetch || sort.fetch != null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        Union union = (Union)call.rel(1);
        ArrayList<RelNode> inputs = new ArrayList<RelNode>();
        boolean ret = true;
        RelMetadataQuery mq = RelMetadataQuery.instance();
        for (RelNode input : union.getInputs()) {
            if (!RelMdUtil.checkInputForCollationAndLimit(mq, input, sort.getCollation(), sort.offset, sort.fetch)) {
                ret = false;
                Sort branchSort = sort.copy(sort.getTraitSet(), input, sort.getCollation(), sort.offset, sort.fetch);
                inputs.add(branchSort);
                continue;
            }
            inputs.add(input);
        }
        if (ret) {
            return;
        }
        Union unionCopy = (Union)union.copy(union.getTraitSet(), inputs, union.all);
        Sort result = sort.copy(sort.getTraitSet(), unionCopy, sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo(result);
    }
}

