pkgbase=dav1d
pkgname=dav1d
pkgver=0.9.0
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Levente Polyak <anthraxx[at]archlinux[dot]org>

cd ${pkgbase}-${pkgver}
ln -s "${srcdir}/dav1d-test-data-${pkgver}" tests/dav1d-test-data

meson setup \
  --prefix        /usr \
  --libdir        lib \
  --libexecdir    lib \
  --sbindir       bin \
  --buildtype     plain \
  --auto-features enabled \
  --wrap-mode     nodownload \
  -D              b_lto=true \
  -D              b_pie=true \
  -Dtestdata_tests=true build
ninja -C build all doc/html

meson test

DESTDIR="${pkgdir}" ninja -C build install
install -Dm 644 README.md CONTRIBUTING.md NEWS -t "${pkgdir}/usr/share/doc/${pkgname}"
install -Dm 644 COPYING -t "${pkgdir}/usr/share/licenses/${pkgname}"

# Package dav1d-docs
install -d "${pkgdir}/dav1d-docs/usr/share/doc/${pkgbase}"
cp -r build/doc/html -t "${pkgdir}/dav1d-docs/usr/share/doc/${pkgbase}"
install -Dm 644 COPYING -t "${pkgdir}/dav1d-docs/usr/share/licenses/${pkgname}"
