# OCCAM - Digital Computational Archive and Curation Service
# Copyright (C) 2014-2016 wilkie
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# This is the init process for x86-64 linux environments running in Docker.

import sys
import json
import subprocess
import os

# Load object.json (the task manifest)

f = open("/home/occam/objects/0/task.json")
task = json.load(f)
f.close()

for obj in task.get('input', []):
  if 'run' in obj:
    # Read the environment variables and run the command
    env = obj['run'].get('env', {})
    command = obj['run'].get('command')

    # Link mounted items
    for link in obj['run'].get('link', []):
      dest = link.get('name')
      src = link.get('target')

      if not (src is None or dest is None):
        # Create intermediate paths
        try:
          os.makedirs(os.path.dirname(dest))
        except:
          pass

        # Create the symlink
        os.symlink(src, dest)

    if not command is None:
      if not isinstance(command, list):
        command = [command]

      if not command[0].strip().startswith("/"):
        # Make it refer to the volume of the object if a relative path
        command[0] = os.path.join(obj.get('paths', {}).get('volume'), command[0].strip())

      try:
        subprocess.Popen(command, env = env, cwd = os.getcwd())
      except:
        print("Failure running %s" % (command), file=sys.stdout)
