pkgbase=libssh
pkgname=(libssh libssh-docs)
pkgver=0.9.6
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Antonio Rojas <arojas@archlinux.org>
# and contributor Tom Gundersen <teg@jklm.no>
# and contributor Andrea Scarpino <andrea@archlinux.org>
# and contributor ice-man <icemanf@gmail.com>
# and contributor sergeantspoon <sergeantspoon@archlinux.us>

# disable the test. It is confused by our clean container setup.
# 'extra-x86-build' uses user 'nobody' that has a record in /etc/passwd file
# but $HOME envvar is set to '/build'. The test expects that $HOME corresponds to passwd file.
sed 's/cmocka_unit_test(torture_path_expand_tilde_unix),//' -i libssh-${pkgver}/tests/unittests/torture_misc.c

mkdir -p build

cd build
cmake ../$pkgname-$pkgver \
  -DCMAKE_INSTALL_PREFIX=/usr \
  -DCMAKE_INSTALL_LIBDIR=lib \
  -DWITH_GSSAPI=OFF \
  -DUNIT_TESTING=ON
make
make docs

make test

make DESTDIR="$pkgdir" install

cd "$srcdir"
pkgdir=$PWD/../build/libssh-docs
#package_libssh-docs() {
#pkgdesc="Documentation for libssh"
#depends=()
#provides=()

mkdir -p "$pkgdir"/usr/share/doc/libssh
cp -r build/doc/html "$pkgdir"/usr/share/doc/libssh
#  cp -r build/doc/man "$pkgdir"/usr/share
#  rm "$pkgdir"/usr/share/man/man3/{bug,deprecated}.*
