unit Txt;

  {$R-}

interface

  uses
    VGA256,
    Buffers;

  const
    Normal      = $00;
    Bold        = $01;
    Shadow      = $02;

  procedure SetFont (i: Integer; Style: Word);
  function Letter (i: Integer): Pointer;
  function TextWidth (S: String): Integer;
  procedure WriteText (X, Y: Integer; S: String; Attr: Byte);
  function CenterX (S: String): Integer;
  procedure CenterText (Y: Integer; S: String; Attr: Byte);

implementation

  const
    bShadow: Boolean = FALSE;
    bBold: Boolean = FALSE;

  var
    Font: Pointer;
    Base: Byte;

  procedure SwissFont; assembler;
  asm
    dw @Space, @Exclamation, @DQuotation, @NumberSign, @Dollar, @Procent
    dw @AndSign, @SQuotation, @LeftBracket, @RightBracket, @Asterisk, @Plus
    dw @Comma, @Hyphen, @Dot, @Slash, @Number0, @Number1, @Number2, @Number3
    dw @Number4, @Number5, @Number6, @Number7, @Number8, @Number9, @Colon
    dw @SemiColon, @SqLBracket, @Equal, @SqRBracket, @QuestionMark, @At
    dw @A1, @B1, @C1, @D1, @E1, @F1, @G1, @H1, @I1, @J1, @K1, @L1, @M1
    dw @N1, @O1, @P1, @Q1, @R1, @S1, @T1, @U1, @V1, @W1, @X1, @Y1, @Z1
    dw @LBracket2, @BackSlash, @RBracket2, @AccCir, @UnderLine, @BSQuot
    dw @A2, @B2, @C2, @D2, @E2, @F2, @G2, @H2, @I2, @J2, @K2, @L2, @M2
    dw @N2, @O2, @P2, @Q2, @R2, @S2, @T2, @U2, @V2, @W2, @X2, @Y2, @Z2
    dw @LBracket3, @VertLine, @RBracket3, @Tilde, @Copyright, @Registered
    dw @TradeMark
  @Space:
    db 8,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00
  @Exclamation:
    db 8,24
    db $00,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$00,$00
    db $18,$18,$18,$00,$00,$00,$00,$00
  @DQuotation:
    db 9,24
    db $00,$00,$B0,$61,$C3,$86,$0D,$1B,$36,$6C,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @NumberSign:
    db 17,24
    db $00,$00,$00,$C6,$00,$8C,$01,$8C,$01,$18,$03,$18,$06,$FF,$7F,$FE
    db $FF,$60,$18,$C0,$18,$80,$31,$F8,$FF,$F3,$FF,$07,$C6,$00,$C6,$00
    db $8C,$01,$0C,$03,$18,$03,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00
  @Dollar:
    db 16,24
    db $80,$00,$80,$00,$E0,$07,$F8,$0F,$98,$1C,$8C,$18,$8C,$30,$8C,$00
    db $9C,$00,$F8,$01,$E0,$0F,$80,$1E,$80,$38,$8C,$30,$8C,$30,$8C,$30
    db $9C,$1C,$F8,$0F,$E0,$07,$80,$00,$80,$00,$00,$00,$00,$00,$00,$00
  @Procent:
    db 22,24
    db $00,$00,$00,$1C,$60,$C0,$1F,$08,$30,$06,$03,$06,$43,$80,$C1,$08
    db $60,$30,$03,$30,$46,$00,$FC,$19,$00,$3E,$02,$00,$C0,$7C,$00,$98
    db $3F,$00,$62,$0C,$C0,$0C,$06,$10,$83,$01,$C6,$60,$80,$60,$0C,$10
    db $F8,$03,$06,$38,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00
  @AndSign:
    db 19,24
    db $00,$00,$00,$3E,$00,$F8,$03,$E0,$38,$00,$83,$01,$18,$0C,$C0,$71
    db $00,$DC,$01,$C0,$07,$80,$1F,$00,$CE,$31,$30,$9C,$C1,$C0,$0F,$06
    db $3C,$30,$C0,$81,$03,$0F,$38,$FC,$C0,$7F,$0E,$F8,$E0,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00
  @SQuotation:
    db 6,24
    db $00,$C3,$30,$08,$42,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00
  @LeftBracket:
    db 7,24
    db $00,$30,$08,$06,$C1,$60,$30,$0C,$06,$83,$C1,$60,$30,$18,$0C,$0C
    db $06,$03,$81,$81,$C0
  @RightBracket:
    db 7,24
    db $80,$81,$C0,$40,$60,$30,$18,$18,$0C,$06,$83,$C1,$60,$30,$18,$06
    db $83,$41,$30,$08,$06
  @Asterisk:
    db 14,24
    db $00,$00,$30,$00,$0C,$30,$13,$FC,$0F,$FC,$00,$1E,$C0,$0F,$38,$07
    db $84,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Plus:
    db 18,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$0C,$00,$30,$00
    db $C0,$00,$00,$03,$00,$0C,$00,$30,$00,$FF,$3F,$FC,$FF,$00,$0C,$00
    db $30,$00,$C0,$00,$00,$03,$00,$0C,$00,$30,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00
  @Comma:
    db 7,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$18,$0C
    db $06,$02,$C1,$20,$00
  @Hyphen:
    db 10,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3F,$FC
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Dot:
    db 6,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$0C,$C3,$00,$00
    db $00,$00
  @Slash:
    db 10,24
    db $00,$00,$06,$18,$20,$C0,$00,$03,$04,$18,$60,$80,$00,$03,$0C,$10
    db $60,$80,$01,$02,$0C,$30,$40,$80,$01,$06,$00,$00,$00,$00
  @Number0:
    db 16,24
    db $00,$00,$00,$00,$E0,$07,$F0,$0F,$38,$1C,$18,$18,$1C,$38,$0C,$30
    db $0C,$30,$0C,$30,$0C,$30,$0C,$30,$0C,$30,$0C,$30,$1C,$38,$18,$18
    db $38,$1C,$F0,$0F,$E0,$07,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Number1:
    db 16,24
    db $00,$00,$00,$00,$00,$03,$00,$03,$80,$03,$F0,$03,$F0,$03,$00,$03
    db $00,$03,$00,$03,$00,$03,$00,$03,$00,$03,$00,$03,$00,$03,$00,$03
    db $00,$03,$00,$03,$00,$03,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Number2:
    db 16,24
    db $00,$00,$00,$00,$E0,$07,$F0,$1F,$38,$1C,$1C,$30,$0C,$30,$0C,$30
    db $00,$30,$00,$18,$00,$1E,$80,$0F,$E0,$03,$F0,$00,$38,$00,$1C,$00
    db $0C,$00,$FC,$3F,$FC,$3F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Number3:
    db 16,24
    db $00,$00,$00,$00,$E0,$07,$F0,$0F,$38,$1C,$18,$18,$0C,$18,$00,$18
    db $00,$1C,$80,$0F,$80,$1F,$00,$38,$00,$30,$0C,$30,$0C,$30,$1C,$38
    db $38,$1C,$F8,$1F,$E0,$07,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Number4:
    db 16,24
    db $00,$00,$00,$00,$00,$0C,$00,$0E,$00,$0F,$80,$0F,$80,$0D,$C0,$0C
    db $60,$0C,$70,$0C,$30,$0C,$18,$0C,$1C,$0C,$FC,$7F,$FC,$7F,$00,$0C
    db $00,$0C,$00,$0C,$00,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Number5:
    db 16,24
    db $00,$00,$00,$00,$F8,$1F,$F8,$1F,$18,$00,$18,$00,$18,$00,$C8,$07
    db $F8,$1F,$18,$1C,$0C,$38,$00,$30,$00,$30,$00,$30,$0C,$30,$0C,$38
    db $38,$1C,$F8,$0F,$E0,$07,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Number6:
    db 16,24
    db $00,$00,$00,$00,$C0,$07,$F0,$1F,$38,$18,$18,$30,$18,$30,$0C,$00
    db $CC,$07,$FC,$1F,$3C,$1C,$1C,$38,$0C,$30,$0C,$30,$0C,$30,$18,$38
    db $38,$1C,$F0,$1F,$E0,$07,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Number7:
    db 16,24
    db $00,$00,$00,$00,$FC,$3F,$FC,$3F,$00,$18,$00,$1C,$00,$0C,$00,$06
    db $00,$07,$00,$03,$80,$03,$80,$01,$C0,$01,$C0,$00,$E0,$00,$E0,$00
    db $60,$00,$60,$00,$70,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Number8:
    db 16,24
    db $00,$00,$00,$00,$E0,$07,$F0,$0F,$38,$1C,$18,$18,$1C,$18,$18,$18
    db $38,$1C,$F0,$0F,$F8,$1F,$38,$1C,$0C,$30,$0C,$30,$0C,$30,$1C,$38
    db $38,$1C,$F8,$1F,$E0,$07,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Number9:
    db 16,24
    db $00,$00,$00,$00,$E0,$07,$F8,$0F,$38,$1C,$1C,$18,$0C,$30,$0C,$30
    db $0C,$30,$1C,$38,$38,$3C,$F8,$3F,$E0,$33,$00,$30,$0C,$18,$0C,$18
    db $18,$1C,$F8,$0F,$E0,$03,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Colon:
    db 6,24
    db $00,$00,$00,$00,$C0,$30,$0C,$00,$00,$00,$00,$00,$0C,$C3,$00,$00
    db $00,$00
  @SemiColon:
    db 6,24
    db $00,$00,$00,$00,$C0,$30,$0C,$00,$00,$00,$00,$00,$0C,$C3,$20,$08
    db $43,$00
  @SqLBracket:
    db 19,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$40,$00,$C0
    db $03,$80,$07,$80,$0F,$00,$0F,$00,$1E,$00,$18,$00,$80,$07,$00,$F0
    db $00,$00,$3E,$00,$80,$07,$00,$F0,$00,$00,$04,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00
  @Equal:
    db 19,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$FC,$FF,$E1,$FF,$0F,$00,$00,$00,$00,$00,$00,$00,$FE
    db $FF,$F0,$FF,$07,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00
  @SqRBracket:
    db 19,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$04,$00,$E0,$01
    db $00,$3C,$00,$80,$0F,$00,$E0,$01,$00,$3C,$00,$00,$03,$00,$0F,$00
    db $1E,$00,$3E,$00,$3C,$00,$78,$00,$40,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00
  @QuestionMark:
    db 14,24
    db $00,$00,$F8,$80,$7F,$E0,$38,$1C,$0C,$03,$C3,$C0,$00,$30,$00,$06
    db $C0,$00,$18,$00,$03,$C0,$00,$30,$00,$00,$00,$00,$C0,$00,$30,$00
    db $0C,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @At:
    db 27,24
    db $00,$00,$00,$00,$E0,$3F,$00,$C0,$01,$07,$80,$03,$E0,$00,$06,$00
    db $06,$18,$00,$60,$60,$E0,$1B,$06,$83,$F1,$30,$18,$06,$87,$61,$30
    db $18,$0C,$C3,$C0,$60,$18,$06,$06,$C3,$30,$30,$0C,$86,$C1,$60,$30
    db $0C,$86,$01,$E3,$68,$06,$18,$3C,$1F,$80,$01,$00,$00,$1C,$00,$08
    db $80,$01,$60,$00,$78,$E0,$01,$00,$FF,$01,$00,$00,$00,$00,$00,$00
    db $00
  @A1:
    db 16,24
    db $00,$00,$C0,$03,$C0,$03,$C0,$03,$E0,$07,$60,$06,$60,$06,$70,$0E
    db $30,$0C,$30,$0C,$38,$1C,$18,$18,$FC,$3F,$FC,$3F,$0C,$30,$0E,$70
    db $06,$70,$06,$60,$07,$E0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @B1:
    db 16,24
    db $00,$00,$FC,$0F,$FC,$3F,$0C,$38,$0C,$30,$0C,$30,$0C,$30,$0C,$30
    db $0C,$38,$FC,$0F,$FC,$3F,$0C,$30,$0C,$60,$0C,$60,$0C,$60,$0C,$60
    db $0C,$30,$FC,$3F,$FC,$0F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @C1:
    db 18,24
    db $00,$00,$00,$7F,$00,$FF,$07,$1E,$3C,$1C,$C0,$30,$00,$E6,$00,$98
    db $01,$00,$06,$00,$18,$00,$60,$00,$80,$01,$00,$06,$80,$39,$00,$C6
    db $00,$1C,$07,$30,$78,$F0,$C0,$FF,$01,$FC,$01,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00
  @D1:
    db 18,24
    db $00,$00,$F0,$7F,$C0,$FF,$07,$03,$3E,$0C,$E0,$30,$00,$C3,$00,$1C
    db $03,$60,$0C,$80,$31,$00,$C6,$00,$18,$03,$60,$0C,$80,$31,$00,$C7
    db $00,$0C,$03,$38,$0C,$70,$F0,$FF,$C1,$FF,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00
  @E1:
    db 16,24
    db $00,$00,$FC,$7F,$FC,$7F,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00
    db $0C,$00,$FC,$3F,$FC,$3F,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00
    db $0C,$00,$FC,$7F,$FC,$7F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @F1:
    db 15,24
    db $00,$00,$FE,$1F,$FF,$8F,$01,$C0,$00,$60,$00,$30,$00,$18,$00,$0C
    db $00,$FE,$0F,$FF,$87,$01,$C0,$00,$60,$00,$30,$00,$18,$00,$0C,$00
    db $06,$00,$03,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @G1:
    db 19,24
    db $00,$00,$00,$FE,$00,$FC,$0F,$70,$E0,$C1,$01,$0C,$06,$E0,$18,$00
    db $C0,$00,$00,$06,$00,$30,$F0,$8F,$81,$7F,$0C,$00,$63,$00,$18,$07
    db $C0,$30,$00,$87,$03,$3C,$78,$F0,$81,$FF,$0D,$F0,$43,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00
  @H1:
    db 18,24
    db $00,$00,$30,$00,$C3,$00,$0C,$03,$30,$0C,$C0,$30,$00,$C3,$00,$0C
    db $03,$30,$FC,$FF,$F0,$FF,$C3,$00,$0C,$03,$30,$0C,$C0,$30,$00,$C3
    db $00,$0C,$03,$30,$0C,$C0,$30,$00,$C3,$00,$0C,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00
  @I1:
    db 6,24
    db $00,$C3,$30,$0C,$C3,$30,$0C,$C3,$30,$0C,$C3,$30,$0C,$C3,$00,$00
    db $00,$00
  @J1:
    db 13,24
    db $00,$00,$C0,$00,$18,$00,$03,$60,$00,$0C,$80,$01,$30,$00,$06,$C0
    db $00,$18,$00,$03,$60,$0C,$8C,$81,$31,$30,$0E,$87,$7F,$E0,$07,$00
    db $00,$00,$00,$00,$00,$00,$00
  @K1:
    db 16,24
    db $00,$00,$0C,$F0,$0C,$38,$0C,$1C,$0C,$0E,$0C,$07,$8C,$03,$CC,$01
    db $EC,$01,$FC,$01,$BC,$03,$1C,$07,$0C,$06,$0C,$0E,$0C,$1C,$0C,$38
    db $0C,$38,$0C,$70,$0C,$E0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @L1:
    db 13,24
    db $00,$80,$01,$30,$00,$06,$C0,$00,$18,$00,$03,$60,$00,$0C,$80,$01
    db $30,$00,$06,$C0,$00,$18,$00,$03,$60,$00,$0C,$80,$FF,$F3,$7F,$00
    db $00,$00,$00,$00,$00,$00,$00
  @M1:
    db 21,24
    db $00,$00,$80,$07,$E0,$F0,$00,$1E,$1E,$C0,$C3,$07,$78,$D8,$80,$0D
    db $1B,$B0,$61,$07,$36,$CC,$60,$86,$19,$CC,$30,$C7,$19,$C6,$18,$C3
    db $18,$63,$18,$77,$0C,$C3,$86,$61,$D8,$30,$0C,$1F,$86,$C1,$C1,$30
    db $38,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @N1:
    db 18,24
    db $00,$00,$70,$00,$C3,$01,$0C,$0F,$30,$7C,$C0,$B0,$01,$C3,$0E,$0C
    db $73,$30,$8C,$C1,$30,$0E,$C3,$70,$0C,$83,$31,$0C,$CE,$30,$70,$C3
    db $80,$0D,$03,$3E,$0C,$F0,$30,$80,$C3,$00,$0E,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00
  @O1:
    db 19,24
    db $00,$00,$00,$FE,$00,$FC,$1F,$F0,$E0,$C1,$01,$1C,$06,$C0,$38,$00
    db $CE,$00,$60,$06,$00,$33,$00,$98,$01,$C0,$0C,$00,$66,$00,$30,$07
    db $C0,$31,$00,$86,$03,$38,$78,$F0,$80,$FF,$03,$F0,$07,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00
  @P1:
    db 16,24
    db $00,$00,$FC,$1F,$FC,$3F,$0C,$70,$0C,$60,$0C,$60,$0C,$60,$0C,$60
    db $0C,$70,$FC,$3F,$FC,$1F,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00
    db $0C,$00,$0C,$00,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Q1:
    db 19,24
    db $00,$00,$00,$FE,$00,$FC,$1F,$F0,$E0,$C1,$01,$1C,$06,$C0,$38,$00
    db $CE,$00,$60,$06,$00,$33,$00,$98,$01,$C0,$0C,$00,$66,$00,$30,$07
    db $C4,$31,$70,$86,$03,$3F,$78,$F0,$80,$FF,$0F,$F0,$E7,$00,$00,$02
    db $00,$00,$00,$00,$00,$00,$00,$00,$00
  @R1:
    db 17,24
    db $00,$00,$F8,$7F,$F0,$FF,$61,$00,$C7,$00,$8C,$01,$18,$03,$30,$06
    db $60,$0C,$70,$F8,$7F,$F0,$FF,$61,$80,$C3,$00,$8E,$01,$18,$03,$30
    db $06,$60,$0C,$C0,$18,$80,$31,$00,$03,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00
  @S1:
    db 16,24
    db $00,$00,$F0,$07,$F8,$1F,$1C,$3C,$0E,$30,$06,$30,$06,$70,$06,$00
    db $3E,$00,$FC,$07,$E0,$3F,$00,$3C,$00,$70,$06,$60,$06,$60,$06,$70
    db $1E,$38,$FC,$1F,$F0,$0F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @T1:
    db 14,24
    db $00,$C0,$FF,$FF,$FF,$03,$03,$C0,$00,$30,$00,$0C,$00,$03,$C0,$00
    db $30,$00,$0C,$00,$03,$C0,$00,$30,$00,$0C,$00,$03,$C0,$00,$30,$00
    db $0C,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @U1:
    db 18,24
    db $00,$00,$30,$00,$C3,$00,$0C,$03,$30,$0C,$C0,$30,$00,$C3,$00,$0C
    db $03,$30,$0C,$C0,$30,$00,$C3,$00,$0C,$03,$30,$0C,$C0,$30,$00,$C3
    db $00,$0C,$07,$38,$38,$70,$C0,$FF,$00,$FE,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00
  @V1:
    db 15,24
    db $00,$80,$03,$B8,$01,$CC,$00,$E6,$80,$63,$C0,$30,$60,$38,$38,$18
    db $0C,$0C,$06,$8E,$03,$C6,$00,$63,$80,$3B,$80,$0D,$C0,$06,$E0,$03
    db $E0,$00,$70,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @W1:
    db 23,24
    db $00,$00,$80,$03,$0C,$B8,$01,$0F,$CC,$80,$07,$E6,$C0,$03,$73,$F0
    db $C1,$31,$98,$61,$18,$CC,$30,$1C,$66,$18,$8E,$33,$0E,$C6,$30,$03
    db $67,$98,$81,$3B,$CC,$80,$0D,$36,$C0,$06,$1E,$E0,$03,$0F,$F0,$81
    db $07,$70,$80,$01,$38,$C0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00
  @X1:
    db 15,24
    db $00,$80,$07,$B8,$03,$8E,$83,$83,$C3,$C0,$71,$C0,$1D,$C0,$06,$E0
    db $03,$E0,$00,$70,$00,$7C,$00,$77,$80,$31,$E0,$38,$38,$38,$0C,$1C
    db $07,$DC,$01,$1C,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Y1:
    db 16,24
    db $00,$00,$0F,$E0,$0E,$70,$1C,$38,$1C,$38,$38,$1C,$30,$0C,$70,$0E
    db $60,$06,$C0,$03,$C0,$03,$80,$01,$80,$01,$80,$01,$80,$01,$80,$01
    db $80,$01,$80,$01,$80,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @Z1:
    db 16,24
    db $00,$00,$FC,$7F,$FC,$7F,$00,$70,$00,$38,$00,$1C,$00,$0E,$00,$0E
    db $00,$07,$80,$03,$C0,$01,$E0,$00,$E0,$00,$70,$00,$38,$00,$1C,$00
    db $0C,$00,$FE,$7F,$FE,$7F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @LBracket2:
    db 10,24
    db $00,$C0,$07,$1F,$0C,$30,$C0,$00,$03,$0C,$30,$C0,$00,$03,$0C,$30
    db $C0,$00,$03,$0C,$30,$C0,$00,$03,$0C,$30,$C0,$00,$1F,$7C
  @BackSlash:
    db 10,24
    db $00,$18,$60,$00,$01,$0C,$30,$80,$00,$06,$18,$40,$00,$03,$0C,$20
    db $80,$01,$06,$10,$C0,$00,$03,$08,$60,$80,$01,$00,$00,$00
  @RBracket2:
    db 10,24
    db $00,$F8,$E0,$03,$0C,$30,$C0,$00,$03,$0C,$30,$C0,$00,$03,$0C,$30
    db $C0,$00,$03,$0C,$30,$C0,$00,$03,$0C,$30,$C0,$E0,$83,$0F
  @AccCir:
    db 21,24
    db $00,$00,$00,$C0,$01,$00,$7C,$00,$C0,$1D,$00,$1C,$07,$C0,$C1,$01
    db $1C,$70,$C0,$01,$1C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @UnderLine:
    db 14,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$F8,$7F
  @BSQuot:
    db 6,24
    db $00,$42,$10,$0C,$C3,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00
  @a2:
    db 14,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3F,$F0,$1F,$0C,$0E
    db $03,$03,$C0,$C0,$3F,$FC,$8D,$03,$63,$C0,$18,$30,$0E,$0F,$7F,$8F
    db $8F,$03,$00,$00,$00,$00,$00,$00,$00,$00
  @b2:
    db 15,24
    db $00,$00,$06,$00,$03,$80,$01,$C0,$00,$60,$00,$30,$1F,$D8,$1F,$3C
    db $1C,$0E,$0C,$03,$8C,$01,$C6,$00,$63,$80,$31,$C0,$38,$30,$3C,$1C
    db $F6,$07,$F3,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @c2:
    db 13,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7C,$C0,$3F,$1C,$C6,$81
    db $19,$00,$03,$60,$00,$0C,$80,$01,$63,$70,$1C,$07,$FF,$C0,$07,$00
    db $00,$00,$00,$00,$00,$00,$00
  @d2:
    db 15,24
    db $00,$00,$00,$0C,$00,$06,$00,$03,$80,$01,$C0,$C0,$67,$F0,$37,$1C
    db $1E,$06,$8E,$01,$C6,$00,$63,$80,$31,$C0,$18,$60,$1C,$38,$1C,$1E
    db $FC,$0D,$7C,$06,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @e2:
    db 14,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3F,$E0,$1F,$1C,$8E
    db $03,$66,$80,$F9,$7F,$FE,$9F,$01,$60,$00,$38,$60,$1C,$0E,$FE,$01
    db $3F,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @f2:
    db 7,24
    db $00,$3C,$9F,$C1,$60,$FC,$FF,$0C,$06,$83,$C1,$60,$30,$18,$0C,$06
    db $03,$00,$00,$00,$00
  @g2:
    db 15,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$C0,$6F,$F0,$37,$1C
    db $1E,$06,$8E,$01,$C6,$00,$63,$80,$31,$C0,$18,$60,$18,$38,$1C,$1E
    db $FC,$0D,$7C,$06,$00,$63,$80,$61,$60,$F0,$3F,$E0,$07
  @h2:
    db 14,24
    db $00,$00,$03,$C0,$00,$30,$00,$0C,$00,$03,$C0,$3C,$B0,$1F,$3C,$0E
    db $07,$C3,$C0,$30,$30,$0C,$0C,$03,$C3,$C0,$30,$30,$0C,$0C,$03,$C3
    db $C0,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @i2:
    db 6,24
    db $00,$C3,$30,$00,$C0,$30,$0C,$C3,$30,$0C,$C3,$30,$0C,$C3,$00,$00
    db $00,$00
  @j2:
    db 6,24
    db $00,$C3,$30,$00,$C0,$30,$0C,$C3,$30,$0C,$C3,$30,$0C,$C3,$30,$0C
    db $F3,$1C
  @k2:
    db 13,24
    db $00,$80,$01,$30,$00,$06,$C0,$00,$18,$00,$03,$67,$30,$0C,$83,$39
    db $B0,$03,$7E,$C0,$1B,$38,$07,$C3,$60,$38,$0C,$86,$81,$31,$70,$00
    db $00,$00,$00,$00,$00,$00,$00
  @l2:
    db 6,24
    db $00,$C3,$30,$0C,$C3,$30,$0C,$C3,$30,$0C,$C3,$30,$0C,$C3,$00,$00
    db $00,$00
  @m2:
    db 20,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$EC
    db $F3,$C1,$BF,$1F,$1C,$8F,$C3,$60,$30,$0C,$06,$C3,$60,$30,$0C,$06
    db $C3,$60,$30,$0C,$06,$C3,$60,$30,$0C,$06,$C3,$60,$30,$0C,$06,$03
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @n2:
    db 14,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$C0,$7E,$F0,$1F,$3C,$0E
    db $07,$C3,$C0,$30,$30,$0C,$0C,$03,$C3,$C0,$30,$30,$0C,$0C,$03,$C3
    db $C0,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @o2:
    db 14,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1F,$E0,$1F,$1C,$0E
    db $03,$67,$80,$19,$60,$06,$98,$01,$66,$80,$31,$70,$1C,$0E,$FE,$01
    db $1F,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @p2:
    db 15,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$1F,$D8,$1F,$3C
    db $1C,$0E,$0C,$03,$8C,$01,$C6,$00,$63,$80,$31,$C0,$38,$30,$3C,$1C
    db $F6,$07,$F3,$81,$01,$C0,$00,$60,$00,$30,$00,$18,$00
  @q2:
    db 15,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$C0,$6F,$F0,$37,$1C
    db $1E,$07,$8E,$01,$C6,$00,$63,$80,$31,$C0,$18,$60,$18,$38,$1C,$1E
    db $FC,$0D,$7C,$06,$00,$03,$80,$01,$C0,$00,$60,$00,$30
  @r2:
    db 8,24
    db $00,$00,$00,$00,$00,$00,$EC,$FC,$3C,$1C,$0C,$0C,$0C,$0C,$0C,$0C
    db $0C,$0C,$0C,$00,$00,$00,$00,$00
  @s2:
    db 12,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$F8,$C0,$3F,$0E,$63,$60,$06
    db $E0,$03,$F8,$03,$7C,$00,$66,$60,$0E,$C7,$3F,$F8,$00,$00,$00,$00
    db $00,$00,$00,$00
  @t2:
    db 7,24
    db $00,$00,$83,$C1,$60,$FC,$FF,$0C,$06,$83,$C1,$60,$30,$18,$0C,$3E
    db $1E,$00,$00,$00,$00
  @u2:
    db 14,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$C0,$C0,$30,$30,$0C,$0C
    db $03,$C3,$C0,$30,$30,$0C,$0C,$03,$C3,$C0,$30,$38,$1C,$0F,$FE,$03
    db $CF,$00,$00,$00,$00,$00,$00,$00,$00,$00
  @v2:
    db 12,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$07,$6E,$60,$06,$E6,$70,$0C
    db $C3,$30,$98,$81,$19,$98,$01,$0F,$F0,$00,$0F,$60,$00,$00,$00,$00
    db $00,$00,$00,$00
  @w2:
    db 18,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$70,$70,$B0
    db $C1,$61,$86,$8F,$19,$36,$E6,$D8,$1C,$73,$33,$CC,$CC,$30,$63,$83
    db $8F,$07,$1E,$1E,$78,$78,$C0,$C1,$00,$03,$03,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00
  @x2:
    db 12,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$07,$EE,$70,$9C,$83,$19,$F8
    db $01,$0F,$70,$00,$0F,$F8,$C1,$39,$0C,$E3,$70,$07,$0E,$00,$00,$00
    db $00,$00,$00,$00
  @y2:
    db 12,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$07,$6E,$60,$06,$E6,$70,$0C
    db $C3,$30,$9C,$83,$19,$98,$81,$0F,$F0,$00,$0F,$60,$00,$06,$60,$00
    db $03,$3E,$E0,$01
  @z2:
    db 14,24
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$C0,$FF,$F1,$7F,$00,$0E
    db $80,$01,$30,$00,$0E,$C0,$01,$38,$00,$07,$E0,$00,$18,$00,$FF,$C7
    db $FF,$01,$00,$00,$00,$00,$00,$00,$00,$00
  @LBracket3:
    db 10,24
    db $00,$00,$0E,$3E,$38,$60,$80,$01,$06,$18,$60,$80,$01,$07,$0F,$3C
    db $C0,$01,$06,$18,$60,$80,$01,$06,$18,$60,$80,$03,$3E,$F0
  @VertLine:
    db 8,24
    db $18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18
    db $18,$18,$18,$18,$18,$18,$18,$18
  @RBracket3:
    db 10,24
    db $00,$3C,$F0,$01,$07,$18,$60,$80,$01,$06,$18,$60,$80,$03,$3C,$F0
    db $E0,$80,$01,$06,$18,$60,$80,$01,$06,$18,$70,$F0,$C1,$01
  @Tilde:
    db 19,24
    db $00,$00,$00,$00,$00,$3C,$60,$F0,$03,$83,$31,$18,$06,$63,$30,$F8
    db $83,$01,$0F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00
  @Copyright:
    db 22,24
    db $00,$00,$00,$00,$00,$00,$F0,$03,$00,$83,$03,$60,$80,$01,$0C,$C0
    db $80,$F1,$61,$20,$C6,$10,$8C,$60,$0C,$31,$00,$42,$0C,$80,$10,$03
    db $20,$C4,$00,$08,$71,$18,$83,$18,$43,$60,$7C,$18,$30,$00,$03,$18
    db $60,$00,$0C,$0E,$00,$7C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00
  @Registered:
    db 22,24
    db $00,$00,$00,$00,$00,$00,$F0,$03,$00,$83,$03,$20,$80,$01,$04,$C0
    db $80,$F9,$63,$20,$C6,$11,$84,$61,$08,$61,$18,$42,$F8,$83,$10,$66
    db $20,$84,$19,$08,$63,$0C,$83,$18,$43,$20,$86,$19,$10,$00,$03,$0C
    db $60,$00,$0C,$0E,$00,$7C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00
  @TradeMark:
    db 20,24
    db $00,$00,$00,$00,$00,$7C,$C6,$00,$61,$0C,$10,$EE,$00,$A1,$0A,$10
    db $AA,$00,$A1,$0B,$10,$92,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
    db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
  end;

  procedure Font8x8; assembler;
  asm
    dw @0d128, @0d129, @0d130, @0d131, @0d132, @0d133, @0d134, @0d135, @0d136
    dw @0d137, @0d138, @0d139, @0d140, @0d141, @0d142, @0d143, @0d144, @0d145
    dw @0d146, @0d147, @0d148, @0d149, @0d150, @0d151, @0d152, @0d153, @0d154
    dw @0d155, @0d156, @0d157, @0d158, @0d159, @0d160, @0d161, @0d162, @0d163
    dw @0d164, @0d165, @0d166, @0d167, @0d168, @0d169, @0d170, @0d171, @0d172
    dw @0d173, @0d174, @0d175, @0d176, @0d177, @0d178, @0d179, @0d180, @0d181
    dw @0d182, @0d183, @0d184, @0d185, @0d186, @0d187, @0d188, @0d189, @0d190
    dw @0d191, @0d192, @0d193, @0d194, @0d195, @0d196, @0d197, @0d198, @0d199
    dw @0d200, @0d201, @0d202, @0d203, @0d204, @0d205, @0d206, @0d207, @0d208
    dw @0d209, @0d210, @0d211, @0d212, @0d213, @0d214, @0d215, @0d216, @0d217
    dw @0d218, @0d219, @0d220, @0d221, @0d222, @0d223, @0d224, @0d225, @0d226
    dw @0d227, @0d228, @0d229, @0d230, @0d231, @0d232, @0d233, @0d234, @0d235
    dw @0d236, @0d237, @0d238, @0d239, @0d240, @0d241, @0d242, @0d243, @0d244
    dw @0d245, @0d246, @0d247, @0d248, @0d249, @0d250, @0d251, @0d252, @0d253
    dw @0d254, @0d255
  @0d128:
    db 8,8
    db $00,$00,$00,$00,$00,$00,$00,$00
  @0d129:
    db 8,8
    db $7E,$81,$A5,$81,$BD,$99,$81,$7E
  @0d130:
    db 8,8
    db $7E,$FF,$DB,$FF,$C3,$E7,$FF,$7E
  @0d131:
    db 8,8
    db $36,$7F,$7F,$7F,$3E,$1C,$08,$00
  @0d132:
    db 8,8
    db $08,$1C,$3E,$7F,$3E,$1C,$08,$00
  @0d133:
    db 8,8
    db $1C,$3E,$1C,$7F,$7F,$3E,$1C,$3E
  @0d134:
    db 8,8
    db $08,$08,$1C,$3E,$7F,$3E,$1C,$3E
  @0d135:
    db 8,8
    db $00,$00,$18,$3C,$3C,$18,$00,$00
  @0d136:
    db 8,8
    db $FF,$FF,$E7,$C3,$C3,$E7,$FF,$FF
  @0d137:
    db 8,8
    db $00,$3C,$66,$42,$42,$66,$3C,$00
  @0d138:
    db 8,8
    db $FF,$C3,$99,$BD,$BD,$99,$C3,$FF
  @0d139:
    db 8,8
    db $F0,$E0,$F0,$BE,$33,$33,$33,$1E
  @0d140:
    db 8,8
    db $3C,$66,$66,$66,$3C,$18,$7E,$18
  @0d141:
    db 8,8
    db $FC,$CC,$FC,$0C,$0C,$0E,$0F,$07
  @0d142:
    db 8,8
    db $FE,$C6,$FE,$C6,$C6,$E6,$67,$03
  @0d143:
    db 8,8
    db $99,$5A,$3C,$E7,$E7,$3C,$5A,$99
  @0d144:
    db 8,8
    db $01,$07,$1F,$7F,$1F,$07,$01,$00
  @0d145:
    db 8,8
    db $40,$70,$7C,$7F,$7C,$70,$40,$00
  @0d146:
    db 8,8
    db $18,$3C,$7E,$18,$18,$7E,$3C,$18
  @0d147:
    db 8,8
    db $66,$66,$66,$66,$66,$00,$66,$00
  @0d148:
    db 8,8
    db $FE,$DB,$DB,$DE,$D8,$D8,$D8,$00
  @0d149:
    db 8,8
    db $7C,$C6,$1C,$36,$36,$1C,$33,$1E
  @0d150:
    db 8,8
    db $00,$00,$00,$00,$7E,$7E,$7E,$00
  @0d151:
    db 8,8
    db $18,$3C,$7E,$18,$7E,$3C,$18,$FF
  @0d152:
    db 8,8
    db $18,$3C,$7E,$18,$18,$18,$18,$00
  @0d153:
    db 8,8
    db $18,$18,$18,$18,$7E,$3C,$18,$00
  @0d154:
    db 8,8
    db $00,$18,$30,$7F,$30,$18,$00,$00
  @0d155:
    db 8,8
    db $00,$0C,$06,$7F,$06,$0C,$00,$00
  @0d156:
    db 8,8
    db $00,$00,$03,$03,$03,$7F,$00,$00
  @0d157:
    db 8,8
    db $00,$24,$66,$FF,$66,$24,$00,$00
  @0d158:
    db 8,8
    db $00,$18,$3C,$7E,$FF,$FF,$00,$00
  @0d159:
    db 8,8
    db $00,$FF,$FF,$7E,$3C,$18,$00,$00
  @0d160:
    db 6,8
    db $00,$00,$00,$00,$00,$00
  @0d161:
    db 3,8
    db $92,$24,$08
  @0d162:
    db 4,8
    db $55,$00,$00,$00
  @0d163:
    db 6,8
    db $8A,$F2,$29,$9F,$A2,$00
  @0d164:
    db 6,8
    db $84,$37,$38,$D8,$43,$00
  @0d165:
    db 8,8
    db $46,$29,$16,$08,$34,$4A,$31,$00
  @0d166:
    db 7,8
    db $0C,$09,$C3,$94,$49,$D8,$00
  @0d167:
    db 3,8
    db $0A,$00,$00
  @0d168:
    db 4,8
    db $24,$11,$21,$04
  @0d169:
    db 4,8
    db $21,$44,$24,$01
  @0d170:
    db 7,8
    db $00,$09,$E3,$C7,$90,$00,$00
  @0d171:
    db 6,8
    db $00,$41,$7C,$04,$01,$00
  @0d172:
    db 3,8
    db $00,$00,$28
  @0d173:
    db 6,8
    db $00,$00,$7C,$00,$00,$00
  @0d174:
    db 2,8
    db $00,$10
  @0d175:
    db 5,8
    db $88,$10,$21,$42,$00
  @0d176:
    db 6,8
    db $4E,$14,$45,$51,$E4,$00
  @0d177:
    db 6,8
    db $84,$41,$10,$04,$E1,$00
  @0d178:
    db 6,8
    db $4E,$04,$31,$42,$F0,$01
  @0d179:
    db 6,8
    db $4E,$04,$31,$50,$E4,$00
  @0d180:
    db 6,8
    db $08,$A3,$24,$1F,$82,$00
  @0d181:
    db 6,8
    db $5F,$F0,$40,$50,$E4,$00
  @0d182:
    db 6,8
    db $8C,$10,$3C,$51,$E4,$00
  @0d183:
    db 6,8
    db $1F,$04,$21,$04,$41,$00
  @0d184:
    db 6,8
    db $4E,$14,$39,$51,$E4,$00
  @0d185:
    db 6,8
    db $4E,$14,$79,$10,$62,$00
  @0d186:
    db 2,8
    db $10,$10
  @0d187:
    db 3,8
    db $80,$00,$28
  @0d188:
    db 5,8
    db $88,$88,$20,$08,$02
  @0d189:
    db 6,8
    db $00,$F0,$01,$C0,$07,$00
  @0d190:
    db 5,8
    db $41,$10,$44,$44,$00
  @0d191:
    db 6,8
    db $4E,$04,$21,$04,$40,$00
  @0d192:
    db 6,8
    db $4E,$D4,$55,$5D,$E0,$00
  @0d193:
    db 6,8
    db $84,$12,$45,$5F,$14,$01
  @0d194:
    db 6,8
    db $4F,$14,$3D,$51,$F4,$00
  @0d195:
    db 7,8
    db $1C,$51,$20,$10,$10,$71,$00
  @0d196:
    db 7,8
    db $8F,$48,$28,$14,$8A,$3C,$00
  @0d197:
    db 6,8
    db $5F,$10,$3C,$41,$F0,$01
  @0d198:
    db 6,8
    db $5F,$10,$3C,$41,$10,$00
  @0d199:
    db 7,8
    db $1C,$51,$20,$10,$13,$F1,$00
  @0d200:
    db 6,8
    db $51,$14,$7D,$51,$14,$01
  @0d201:
    db 2,8
    db $55,$15
  @0d202:
    db 6,8
    db $1E,$04,$41,$51,$E4,$00
  @0d203:
    db 6,8
    db $51,$52,$0C,$45,$12,$01
  @0d204:
    db 6,8
    db $41,$10,$04,$41,$F0,$01
  @0d205:
    db 8,8
    db $41,$63,$55,$49,$41,$41,$41,$00
  @0d206:
    db 6,8
    db $D1,$54,$65,$51,$14,$01
  @0d207:
    db 8,8
    db $1C,$22,$41,$41,$41,$22,$1C,$00
  @0d208:
    db 6,8
    db $4F,$14,$3D,$41,$10,$00
  @0d209:
    db 6,8
    db $4E,$14,$45,$91,$83,$01
  @0d210:
    db 6,8
    db $4F,$14,$3D,$45,$12,$01
  @0d211:
    db 6,8
    db $4E,$14,$38,$50,$E4,$00
  @0d212:
    db 6,8
    db $1F,$41,$10,$04,$41,$00
  @0d213:
    db 6,8
    db $51,$14,$45,$51,$E4,$00
  @0d214:
    db 6,8
    db $51,$14,$45,$91,$42,$00
  @0d215:
    db 8,8
    db $41,$41,$41,$49,$55,$63,$41,$00
  @0d216:
    db 8,8
    db $41,$22,$14,$08,$14,$22,$41,$00
  @0d217:
    db 8,8
    db $41,$22,$14,$08,$08,$08,$08,$00
  @0d218:
    db 7,8
    db $3F,$10,$04,$41,$10,$FC,$00
  @0d219:
    db 3,8
    db $4B,$92,$0C
  @0d220:
    db 5,8
    db $41,$08,$42,$10,$02
  @0d221:
    db 3,8
    db $93,$24,$0D
  @0d222:
    db 6,8
    db $00,$A1,$44,$00,$00,$00
  @0d223:
    db 6,8
    db $00,$00,$00,$00,$00,$FC
  @0d224:
    db 3,8
    db $11,$00,$00
  @0d225:
    db 5,8
    db $00,$B8,$94,$92,$05
  @0d226:
    db 5,8
    db $21,$9C,$94,$D2,$01
  @0d227:
    db 5,8
    db $00,$B8,$10,$82,$03
  @0d228:
    db 5,8
    db $08,$B9,$94,$92,$05
  @0d229:
    db 6,8
    db $00,$E0,$44,$5F,$E0,$00
  @0d230:
    db 4,8
    db $2C,$27,$22,$02
  @0d231:
    db 5,9
    db $00,$B8,$94,$92,$43,$80
  @0d232:
    db 5,8
    db $21,$9C,$94,$52,$02
  @0d233:
    db 2,8
    db $51,$15
  @0d234:
    db 3,9
    db $82,$24,$49,$00
  @0d235:
    db 5,8
    db $21,$A4,$32,$4A,$02
  @0d236:
    db 2,8
    db $55,$15
  @0d237:
    db 8,8
    db $00,$00,$37,$49,$49,$49,$49,$00
  @0d238:
    db 5,8
    db $00,$9C,$94,$52,$02
  @0d239:
    db 6,8
    db $00,$E0,$44,$51,$E4,$00
  @0d240:
    db 5,9
    db $00,$9C,$94,$D2,$09,$40
  @0d241:
    db 5,9
    db $00,$B8,$94,$92,$43,$00
  @0d242:
    db 5,8
    db $00,$98,$14,$42,$00
  @0d243:
    db 6,8
    db $00,$E0,$05,$0E,$F4,$00
  @0d244:
    db 5,8
    db $40,$3C,$21,$04,$03
  @0d245:
    db 5,8
    db $00,$A4,$94,$92,$03
  @0d246:
    db 6,8
    db $00,$10,$45,$91,$42,$00
  @0d247:
    db 8,8
    db $00,$00,$49,$49,$49,$49,$36,$00
  @0d248:
    db 6,8
    db $00,$10,$29,$84,$12,$01
  @0d249:
    db 5,9
    db $00,$A4,$94,$92,$43,$C0
  @0d250:
    db 6,8
    db $00,$F0,$21,$84,$F0,$01
  @0d251:
    db 4,8
    db $24,$12,$22,$04
  @0d252:
    db 2,8
    db $15,$15
  @0d253:
    db 4,8
    db $21,$42,$22,$01
  @0d254:
    db 7,8
    db $A6,$0C,$00,$00,$00,$00,$00
  @0d255:
    db 6,8
    db $00,$40,$28,$51,$F4,$01
  end;

  procedure SetFont (i: Integer; Style: Word);
  begin
    case i of
      0: begin
           Font := @Font8x8;
           Base := 0;
         end;
      1: begin
           Font := @SwissFont;
           Base := 32;
         end;
    end;
    bBold := Style or Bold = Style;
    bShadow := Style or Shadow = Style;
  end;

  function Letter (i: Integer): pointer;
    var
      W1,
      W2: Word;
      P: Pointer;
  begin
    P := Font;
    Dec (i, Base);
    asm
        push    ds
        lds     si, P
        mov     ax, i
        shl     ax, 1
        add     si, ax
        lodsw
        mov     W1, ds
        mov     W2, ax
        pop     ds
    end;
    Letter := Ptr (W1, W2);
  end;

  function TextWidth (S: String): Integer;
    var
      P: Pointer;
      Width: Integer;
      i: Byte;
      A: Word;
  begin
    P := Font;
    Width := 0;
    for i := 1 to Length (S) do
    begin
      A := Ord (S [i]) shl 1;
      Dec (A, 2 * Base);
      asm
        push    ds
        lds     si, P
        mov     ax, A
        add     si, ax
        cld
        lodsw
        mov     si, ax
        lodsb
        mov     ah, 0
        add     Width, ax
        pop     ds
      end;
      Inc (Width, Byte (bBold) + Byte (bShadow));
    end;
    TextWidth := Width;
  end;

  procedure WriteText (X, Y: Integer; S: String; Attr: Byte);
    var
      i: Byte;
      C: Char;
  begin
    i := 1;
    repeat
      C := S [i];
      if bShadow then
        DrawBitmap (X + 1, Y + 1, Letter (Ord (C))^, 16);
      if bBold then
      begin
        if bShadow then
          DrawBitmap (X, Y + 1, Letter (Ord (C))^, 16);
        DrawBitmap (X - 1, Y, Letter (Ord (C))^, Attr);
      end;
      DrawBitmap (X, Y, Letter (Ord (C))^, Attr);
      inc (X, TextWidth (C));
      Inc (i);
    until i > Length (S);
  end;

  function CenterX (S: String): Integer;
  begin
    CenterX := XView + (SCREEN_WIDTH - TextWidth (S)) shr 1;
  end;

  procedure CenterText (Y: Integer; S: String; Attr: Byte);
  begin
    WriteText (CenterX (S), Y, S, Attr);
  end;

begin
  SetFont (0, Normal);
end.
